/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.BlockInventoryProxy;
import com.tom.storagemod.tile.IProxy;
import com.tom.storagemod.tile.TileEntityPainted;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryProxy
extends TileEntityPainted
implements ITickableTileEntity {
    private LazyOptional<IItemHandler> invHandler;
    private LazyOptional<IItemHandler> pointedAt;
    private LazyOptional<IItemHandler> filter;
    private boolean ignoreCount;
    private int globalCountLimit = 64;
    private boolean calling;

    public TileEntityInventoryProxy() {
        super(StorageMod.invProxyTile);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        BlockState state;
        Direction facing;
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != (facing = (Direction)(state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177229_b((Property)BlockInventoryProxy.FACING))) {
            if (this.invHandler == null) {
                this.invHandler = LazyOptional.of(() -> new InvHandler());
            }
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public <R> R call(Function<IItemHandler, R> func, Predicate<IItemHandler> accessCheck, R def) {
        IItemHandler ih;
        if (this.calling) {
            return def;
        }
        this.calling = true;
        if (this.pointedAt != null && accessCheck.test(ih = (IItemHandler)this.pointedAt.orElse((Object)EmptyHandler.INSTANCE))) {
            R r = func.apply(ih);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return def;
    }

    private int getMaxCountPerStack() {
        return this.filter == null ? 64 : this.globalCountLimit;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 18L) {
            TileEntity te;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            Direction facing = (Direction)state.func_177229_b((Property)BlockInventoryProxy.FACING);
            BlockInventoryProxy.DirectionWithNull filter = (BlockInventoryProxy.DirectionWithNull)((Object)state.func_177229_b(BlockInventoryProxy.FILTER_FACING));
            if (!(this.pointedAt != null && this.pointedAt.isPresent() || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || te instanceof TileEntityInventoryProxy)) {
                this.pointedAt = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            }
            this.ignoreCount = false;
            this.globalCountLimit = 64;
            if (filter != BlockInventoryProxy.DirectionWithNull.NULL) {
                te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(filter.getDir()));
                if (te != null && !(te instanceof TileEntityInventoryProxy)) {
                    this.filter = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (te instanceof INamedContainerProvider) {
                        String[] sp;
                        block8: for (String string : sp = ((INamedContainerProvider)te).func_145748_c_().getString().split(",")) {
                            String[] sp2 = string.split("=");
                            String key = sp2[0];
                            String value = sp2.length > 1 ? sp2[1] : "";
                            switch (key) {
                                case "ignoreSize": {
                                    this.ignoreCount = true;
                                    continue block8;
                                }
                                case "maxCount": {
                                    if (value.isEmpty()) continue block8;
                                    this.globalCountLimit = this.parseInt(value, 64);
                                    continue block8;
                                }
                            }
                        }
                    } else {
                        this.ignoreCount = false;
                        this.globalCountLimit = 64;
                    }
                }
            } else {
                this.filter = null;
            }
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    private int parseInt(String value, int def) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public int getComparatorOutput() {
        return this.call(inventory -> {
            if (this.filter == null || !this.filter.isPresent()) {
                return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)inventory);
            }
            int i = 0;
            float f = 0.0f;
            IItemHandler filter = (IItemHandler)this.filter.orElse((Object)EmptyHandler.INSTANCE);
            int fsize = filter.getSlots();
            for (int j = 0; j < inventory.getSlots(); ++j) {
                ItemStack fstack;
                ItemStack itemStack = inventory.getStackInSlot(j);
                ItemStack itemStack2 = fstack = fsize > j ? filter.getStackInSlot(j) : ItemStack.field_190927_a;
                if (itemStack.func_190926_b() || !fstack.func_190926_b() && (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)fstack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)fstack))) continue;
                f += (float)(itemStack.func_190916_E() / Math.min(this.ignoreCount || fstack.func_190926_b() ? this.globalCountLimit : fstack.func_190916_E(), itemStack.func_77976_d()));
                ++i;
            }
            return MathHelper.func_76141_d((float)((f /= (float)inventory.getSlots()) * 14.0f)) + (i > 0 ? 1 : 0);
        }, i -> true, 0);
    }

    private boolean checkFilter(IItemHandler w, int slot, ItemStack stack) {
        IItemHandler ih;
        if (this.filter != null && this.filter.isPresent() && (ih = (IItemHandler)this.filter.orElse((Object)EmptyHandler.INSTANCE)).getSlots() > slot) {
            ItemStack fstack = ih.getStackInSlot(slot);
            if (fstack.func_190926_b()) {
                return true;
            }
            if (stack == null) {
                stack = w.getStackInSlot(slot);
                return ItemStack.func_179545_c((ItemStack)stack, (ItemStack)fstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)fstack);
            }
            if (ItemStack.func_179545_c((ItemStack)stack, (ItemStack)fstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)fstack)) {
                if (this.ignoreCount) {
                    return true;
                }
                int count = w.getStackInSlot(slot).func_190916_E();
                if (count < fstack.func_190916_E()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private class InvHandler
    implements IItemHandler,
    IProxy {
        private InvHandler() {
        }

        public int getSlots() {
            return TileEntityInventoryProxy.this.call(IItemHandler::getSlots, i -> true, 0);
        }

        public ItemStack getStackInSlot(int slot) {
            return TileEntityInventoryProxy.this.call(i -> i.getStackInSlot(slot), i -> TileEntityInventoryProxy.this.checkFilter(i, slot, null), ItemStack.field_190927_a);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return TileEntityInventoryProxy.this.call(i -> i.insertItem(slot, stack, simulate), i -> TileEntityInventoryProxy.this.checkFilter(i, slot, stack), stack);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return TileEntityInventoryProxy.this.call(i -> i.extractItem(slot, amount, simulate), i -> TileEntityInventoryProxy.this.checkFilter(i, slot, null), ItemStack.field_190927_a);
        }

        public int getSlotLimit(int slot) {
            return TileEntityInventoryProxy.this.call(i -> Math.min(i.getSlotLimit(slot), TileEntityInventoryProxy.this.getMaxCountPerStack()), i -> true, 0);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileEntityInventoryProxy.this.call(i -> i.isItemValid(slot, stack), i -> TileEntityInventoryProxy.this.checkFilter(i, slot, stack), false);
        }

        @Override
        public IItemHandler get() {
            if (TileEntityInventoryProxy.this.pointedAt != null) {
                return (IItemHandler)TileEntityInventoryProxy.this.pointedAt.orElse(null);
            }
            return null;
        }
    }
}

